<?php declare(strict_types = 1);

namespace Pages\Model\Navigation;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Pages\Model\Pages;

class Page extends BaseNavigation implements INavigationItem
{
	protected $title     = 'onePage';
	protected $presenter = 'Pages:Front:Default';
	protected $action    = 'page';

	/** @var Pages */
	protected $pagesService;

	public function __construct(Pages $pages)
	{
		$this->pagesService = $pages;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		$pages = [];
		foreach ($this->pagesService->getAll() as $page)
			$pages[$page->getId()] = $page->title;

		$container->addSelect('page', 'pages.navigationForm.page', $pages)->setRequired();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return (
			$this->presenter == $presenter && $this->action == $action
		);
	}

	public function routerIn($navigation, $urlParams = [])
	{
		if (isset($urlParams['path']) && isset($navigation->alias)) {
			$alias = explode('/', $urlParams['path']);
			$alias = end($alias);
			if ($alias == $navigation->alias) {

				return [
					'presenter' => $this->presenter,
					'action'    => $this->action,
					'id'        => $navigation->componentParams['page'],
				];
			}
		}

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => null,
		];
	}

	public function routerOut($navigation, &$id)
	{
		if ($navigation instanceof Navigation == false)
			return false;

		return $navigation->isHomepage ? '/' : '/' . $navigation->alias;
	}
}