<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Checkbox extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'checkbox';

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$formContainer->addCheckbox($this->getName(), $this->getTitle());

		if (isset($params['default']))
			$formContainer[$this->getName()]->setDefaultValue($params['default']);
	}

	public function render($params)
	{
		return $this->getDefault();
	}
}