<?php declare(strict_types = 1);

namespace Pages\FrontModule\Presenters;

use Pages\Model\Paths;
use Pages\FrontModule\Model\TemplatePages;

class DefaultPresenter extends BasePresenter
{

	/** @var TemplatePages */
	protected $templatePagesService;

	/** @var Paths */
	protected $pathsService;

	public function __construct(TemplatePages $templatePages, Paths $paths)
	{
		$this->templatePagesService = $templatePages;
		$this->pathsService         = $paths;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionTemplatePage(?int $id = null)
	{
		$id   = $id ?: (int) $this->getActiveNavigation()->componentParams['templatePage'];
		$page = $this->templatePagesService->get($id);

		if (!$page)
			$this->error('pages.page.notFound');

		$this->template->pageClass          .= ' template-page tp-' . $page->getId();
		$this->template->templateTextValues = $page->getTexts();
		$this->template->setFile($this->pathsService->getTemplatePagesFile($page->getTemplate()));
	}
}
