<?php declare(strict_types = 1);

namespace Migrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;
use Nette\Neon\Neon;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20190821093131 extends AbstractMigration
{
	protected static $blocks = [];

	protected static $pages = [];

	public function up(Schema $schema): void
	{
		// this up() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		self::$blocks = $this->connection->fetchAll("SELECT * FROM pages__template_block");
		self::$pages  = $this->connection->fetchAll("SELECT * FROM pages__template_page");

		$this->addSql('CREATE TABLE pages__template_block_text (lang VARCHAR(2) NOT NULL, block_id INT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, texts LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_18E29E9CE9ED820C (block_id), PRIMARY KEY(block_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('CREATE TABLE pages__template_page_text (lang VARCHAR(2) NOT NULL, page_id INT NOT NULL, is_published SMALLINT DEFAULT 1 NOT NULL, texts LONGTEXT NOT NULL COMMENT \'(DC2Type:array)\', INDEX IDX_6E9A96D0C4663E4 (page_id), PRIMARY KEY(page_id, lang)) DEFAULT CHARACTER SET UTF8 COLLATE UTF8_unicode_ci ENGINE = InnoDB');
		$this->addSql('ALTER TABLE pages__template_block_text ADD CONSTRAINT FK_18E29E9CE9ED820C FOREIGN KEY (block_id) REFERENCES pages__template_block (id) ON DELETE CASCADE');
		$this->addSql('ALTER TABLE pages__template_page_text ADD CONSTRAINT FK_6E9A96D0C4663E4 FOREIGN KEY (page_id) REFERENCES pages__template_page (id) ON DELETE CASCADE');
		$this->addSql('DROP TABLE pages__page');
		$this->addSql('ALTER TABLE pages__template_block DROP is_published, DROP texts');
		$this->addSql('ALTER TABLE pages__template_page DROP is_published, DROP texts');
	}

	public function postUp(Schema $schema)
	{
		parent::postUp($schema);

		$configFile  = @file_get_contents(APP_DIR . '/config/app/parameters.neon');
		$appConfig   = Neon::decode($configFile);
		$defaultLang = $appConfig['parameters']['translation']['default'] ?? 'cs';

		foreach (self::$blocks as $v) {
			$this->connection->insert('pages__template_block_text', [
				'block_id'     => $v['id'],
				'is_published' => $v['is_published'] ?: 1,
				'lang'         => $defaultLang,
				'texts'        => $v['texts'] ?: [],
			]);
		}

		foreach (self::$pages as $v) {
			$this->connection->insert('pages__template_page_text', [
				'page_id'      => $v['id'],
				'is_published' => $v['is_published'] ?: 1,
				'lang'         => $defaultLang,
				'texts'        => $v['texts'] ?: [],
			]);
		}
	}

	public function down(Schema $schema): void
	{
		// this down() migration is auto-generated, please modify it to your needs
		$this->abortIf($this->connection->getDatabasePlatform()->getName() !== 'mysql', 'Migration can only be executed safely on \'mysql\'.');

		$this->addSql('CREATE TABLE pages__page (id INT AUTO_INCREMENT NOT NULL, title VARCHAR(255) NOT NULL COLLATE utf8_unicode_ci, is_published SMALLINT NOT NULL, text LONGTEXT DEFAULT NULL COLLATE utf8_unicode_ci, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci ENGINE = InnoDB COMMENT = \'\' ');
		$this->addSql('DROP TABLE pages__template_block_text');
		$this->addSql('DROP TABLE pages__template_page_text');
		$this->addSql('ALTER TABLE pages__template_block ADD is_published SMALLINT NOT NULL, ADD texts LONGTEXT NOT NULL COLLATE utf8_unicode_ci COMMENT \'(DC2Type:array)\'');
		$this->addSql('ALTER TABLE pages__template_page ADD is_published SMALLINT NOT NULL, ADD texts LONGTEXT NOT NULL COLLATE utf8_unicode_ci COMMENT \'(DC2Type:array)\'');
	}
}
