<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="pages__template_page")
 * @ORM\Entity
 * @ORM\EntityListeners({"TemplatePageListener", "Core\Model\Entities\TranslateListener"})
 */
class TemplatePage
{
	use Identifier;
	use MagicAccessors;
	use TTranslateListener;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var TemplatePageText[]
	 * @ORM\OneToMany(targetEntity="TemplatePageText", mappedBy="page", indexBy="lang")
	 */
	protected $texts;

	/**
	 * @var string
	 * @ORM\Column(name="template", type="string", length=255, nullable=false)
	 */
	public $template;

	public function __construct(string $title, string $template)
	{
		$this->title    = $title;
		$this->template = $template;
		$this->texts    = new ArrayCollection();
	}

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?TemplatePageText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return TemplatePageText[]|ArrayCollection */
	public function getTexts() { return $this->texts; }
}
