<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Lang\Langs;
use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Kdyby\Events\Subscriber;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;
use Pages\FrontModule\Model\TemplatePages;

class TemplatePageListener implements Subscriber
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Session */
	private $session;

	/** @var Langs */
	protected $langs;

	protected $fields = false;

	public function __construct(IStorage $cacheStorage, Session $session, Langs $langs)
	{
		$this->session = $session;
		$this->cache   = new Cache($cacheStorage, TemplatePages::CACHE_NAMESPACE);
		$this->langs   = $langs;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param TemplatePage       $templatePage
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler(TemplatePage $templatePage, LifecycleEventArgs $event)
	{
		if ($templatePage->getId()) {
			foreach ($this->langs->getLangs(false) as $lang)
				$this->cache->remove('templatePage/' . $templatePage->getId() . '/' . $lang->getTag());
		}

		$this->cache->clean([
			Cache::TAGS => [TemplatePages::CACHE_NAMESPACE],
		]);
	}
}
