<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Nette\Application\UI\ITemplateFactory;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Pages\Model\Paths;
use Pages\FrontModule\Model\TemplateBlocks;

class Block extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'block';

	/** @var TemplateBlocks */
	protected $templateBlocksService;

	/** @var ITemplateFactory */
	protected $templateFactory;

	/** @var Paths */
	protected $pathsService;

	/**
	 * Block constructor.
	 *
	 * @param TemplateBlocks   $templateBlocksService
	 * @param ITemplateFactory $templateFactory
	 * @param Paths            $paths
	 */
	public function __construct(TemplateBlocks $templateBlocksService, ITemplateFactory $templateFactory, Paths $paths)
	{
		$this->templateBlocksService = $templateBlocksService;
		$this->templateFactory       = $templateFactory;
		$this->pathsService          = $paths;
	}

	public function loadContainer($formContainer, $params = [])
	{
		$blocks    = ['' => ''];
		$allBlocks = $this->templateBlocksService->getEr()->findBy([], ['title' => 'ASC']);
		foreach ($allBlocks as $b) {
			$blocks[$b->getId()] = $b->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $blocks);
	}

	/**
	 * @param $params
	 *
	 * @return mixed|string
	 * @throws \Doctrine\ORM\NonUniqueResultException
	 */
	public function render($params)
	{
		$block = $this->templateBlocksService->get($this->getDefault());

		if (!$block)
			return '';

		// TODO přesunout do služby
		$template                  = $block->template;
		$latte                     = $this->templateFactory->createTemplate();
		$latte->templateTextValues = $block->getTexts();
		$latte->setFile($this->pathsService->getTemplateBlocksFile($template));
		$content = $latte->renderToString();

		return $content;
	}
}
