<?php declare(strict_types = 1);

namespace Pages\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Pages\Model\Entities\TemplatePage;

/**
 * Class TemplatePages
 * @package Pages\AdminModule/Model
 *
 * @method TemplatePage|object|null getReference($id)
 * @method TemplatePage[]|null getAll()
 * @method TemplatePage|null get($id)
 */
class TemplatePages extends BaseEntityService
{
	protected $entityClass = TemplatePage::class;

	public function getBySiteForSelectOption(string $site): array
	{
		return $this->getEr()->findPairs(['site' => $site], 'title', ['title']);
	}
}
