<?php declare(strict_types = 1);

namespace Pages\AdminModule\Presenters;

use Core\Model\UI\Form\BaseForm;
use Nette\Application\ForbiddenRequestException;
use Nette\Http\IResponse;
use Pages\AdminModule\Components\ITemplateBlockFormFactory;
use Pages\AdminModule\Components\ITemplateBlocksGridFactory;
use Pages\Model\Entities\TemplateBlock;

class TemplateBlocksPresenter extends BasePresenter
{
	protected function startup()
	{
		parent::startup();
		$this['title']->setTitle($this->translator->translate('pages.title.blocks'));
		$this->setHeader('pages.title.blocks', 'fas fa-th-large');
	}

	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);
		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'accessTemplateBlocks')) {
			throw new ForbiddenRequestException();
		}
	}

	public function actionDefault()
	{
		$this['navigation']->setData(['header' => [
			[
				'title' => 'pages.menu.newBlock',
				'link'  => 'TemplateBlocks:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('pages.title.newBlock'));
		$this->setHeader('pages.title.newBlock', 'fas fa-th-large');
	}

	public function actionEdit($id)
	{
		$page = $this->em->getRepository(TemplateBlock::class)->find($id);

		if (!$page)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('pages.title.editTemplateBlock'), $page->title);
		$this->setHeader('pages.title.editTemplateBlock', 'fas fa-th-large');
	}

	protected function createComponentTemplateBlocksGrid(ITemplateBlocksGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentTemplateBlockForm(ITemplateBlockFormFactory $factory)
	{
		$control = $factory->create();

		if ($this->getParameter('id'))
			$control->setBlock($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('edit', $form->getCustomData('templateBlockId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function() {
			$this->redirect('default');
		};
		$control['form']->onCancel[]              = function() {
			$this->redirect('default');
		};

		return $control;
	}

}
