<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model\Dao;

use Nette\SmartObject;

/**
 * Class DaoTemplateBlock
 * @package Pages\FrontModule\Model\Dao
 * @property-read int $id
 * @property-read string $title
 * @property-read array $texts
 * @property-read string $template
 */
class DaoTemplateBlock
{
	use SmartObject;

	/** @var int */
	protected $id;

	/** @var string */
	protected $title;

	/** @var array */
	protected $texts = [];

	/** @var string */
	protected $template;

	public function __construct(int $id, string $title, array $texts, string $template)
	{
		$this->id       = $id;
		$this->title    = $title;
		$this->texts    = $texts;
		$this->template = $template;
	}

	public function getId(): int { return $this->id; }

	public function getTitle(): string { return $this->title; }

	public function getTexts(): array { return $this->texts; }

	public function getText(string $key) { return $this->texts[$key] ?? null; }

	public function getTemplate(): string { return $this->template; }
}
