<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="pages__template_block")
 * @ORM\Entity
 * @ORM\EntityListeners({"TemplateBlockListener", "Core\Model\Entities\TranslateListener"})
 */
class TemplateBlock
{
	use TId;
	use TTranslateListener;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var TemplateBlockText[]
	 * @ORM\OneToMany(targetEntity="TemplateBlockText", mappedBy="block", indexBy="lang")
	 */
	protected $texts;

	/**
	 * @var string
	 * @ORM\Column(name="template", type="string", length=255, nullable=false)
	 */
	public $template;

	public function __construct(string $title, string $template)
	{
		$this->title    = $title;
		$this->template = $template;
		$this->texts    = new ArrayCollection();
	}

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?TemplateBlockText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return TemplateBlockText[]|ArrayCollection */
	public function getTexts() { return $this->texts; }
}
