<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\Caching\IStorage;
use Nette\Http\Session;
use Nette\SmartObject;
use Pages\FrontModule\Model\TemplateBlocks;

class TemplateBlockListener implements EventSubscriberInterface
{
	use SmartObject;

	/** @var Cache */
	private $cache;

	/** @var Session */
	private $session;

	protected $fields = false;

	public function __construct(IStorage $cacheStorage, Session $session)
	{
		$this->session = $session;
		$this->cache   = new Cache($cacheStorage, TemplateBlocks::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostPersist
	 * @ORM\PostUpdate
	 * @ORM\PostRemove
	 *
	 * @param TemplateBlock      $templateBlock
	 * @param LifecycleEventArgs $event
	 */
	public function postHandler(TemplateBlock $templateBlock, LifecycleEventArgs $event)
	{
		$this->cache->clean([
			Cache::TAGS => [TemplateBlocks::CACHE_NAMESPACE],
		]);
	}
}
