<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\Site;
use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="pages__template_page")
 * @ORM\Entity
 * @ORM\EntityListeners({"TemplatePageListener", "Core\Model\Entities\TranslateListener"})
 */
class TemplatePage
{
	use TId;
	use TTranslateListener;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var Site
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site", referencedColumnName="ident", onDelete="CASCADE")
	 */
	public $site;

	/**
	 * @var TemplatePageText[]
	 * @ORM\OneToMany(targetEntity="TemplatePageText", mappedBy="page", indexBy="lang")
	 */
	protected $texts;

	/**
	 * @var string
	 * @ORM\Column(name="template", type="string", length=255, nullable=false)
	 */
	public $template;

	/**
	 * @var TemplatePageGroup
	 * @ORM\ManyToOne(targetEntity="TemplatePageGroup", inversedBy="pages")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="SET NULL", nullable=true)
	 */
	public $group;

	public function __construct(string $title, string $template)
	{
		$this->title    = $title;
		$this->template = $template;
		$this->texts    = new ArrayCollection();
	}

	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText(?string $lang = null): ?TemplatePageText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return TemplatePageText[]|ArrayCollection */
	public function getTexts() { return $this->texts; }
}
