<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="pages__template_page_group")
 * @ORM\Entity
 */
class TemplatePageGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var TemplatePage[]
	 * @ORM\OneToMany(targetEntity="TemplatePage", mappedBy="group")
	 */
	protected $pages;

	public function __construct(string $title)
	{
		$this->title = $title;
		$this->pages = new ArrayCollection();
	}

	/** @return TemplatePage[] */
	protected function getBlocks() { return $this->pages; }
}
