<?php declare(strict_types = 1);

namespace Pages\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\AdminModule\Components\NavigationForm;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Pages\AdminModule\Model\TemplatePages;

class TemplatePage extends BaseNavigation implements INavigationItem
{
	protected $title = 'templatePage';
	protected $presenter = 'Pages:Front:Default';
	protected $action = 'templatePage';

	/** @var string */
	protected $navFormSite;

	/** @var TemplatePages */
	protected $templatePagesService;

	public function __construct(TemplatePages $templatePages)
	{
		$this->templatePagesService = $templatePages;
	}

	public function navigationFormCustomHandle(NavigationForm $component, array $data = []): void
	{
		$this->navFormSite = $data['site'];
		$component->loadComponent($data['componentId']);
		$component->redrawControl('component');
	}

	/**
	 * @param BaseForm $baseForm
	 *
	 * @return BaseContainer
	 */
	public function getFormContainer(BaseForm $baseForm)
	{
		$container = new BaseContainer();
		$site      = $this->navFormSite ?: $baseForm->getCustomData('loadComponent')['site'];
		$pages     = $this->templatePagesService->getBySiteForSelectOption($site ?? $baseForm['site']->getValue());

		$container->addSelect('templatePage', 'pages.navigationForm.page', $pages)->setRequired();

		// TODO nejak zautomatizovat, stejne jako kategorie u eshopu
		if ($baseForm->getParent()->lookup(null, false)) {
			$componentId = $baseForm->getParent()->getParameter('componentId');
			if ($componentId)
				$container['templatePage']->setAttribute('data-custom-link', $baseForm->getParent()->link('componentCustom!', [$componentId]));
		} else {
			$baseForm->onAnchor[] = function () use ($container, $baseForm) {
				$container['templatePage']->setAttribute('data-custom-link', $baseForm->getParent()->link('componentCustom!', [$baseForm->getValues()->componentType]));
			};
		}

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return (
			$this->presenter == $presenter && $this->action == $action
		);
	}

	public function routerIn($navigation, $urlParams = [])
	{
		if ($urlParams['path']) {
			$tmp = explode('/', $urlParams['path']);

			if (end($tmp) !== $navigation->alias)
				return null;
		}

		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => $navigation->componentParams['templatePage'],
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '/' : '/' . $navigation->alias;
	}
}
