<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Nette\Application\UI\ITemplateFactory;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Pages\Model\Paths;
use Pages\FrontModule\Model\TemplateBlocks;

class Blocks extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'blocks';

	/** @var TemplateBlocks */
	protected $templateBlocksService;

	/** @var @var ITemplateFactory */
	protected $templateFactory;

	/** @var Paths */
	protected $pathsService;

	/**
	 * Block constructor.
	 *
	 * @param TemplateBlocks   $templateBlocksService
	 * @param ITemplateFactory $templateFactory
	 * @param Paths            $paths
	 */
	public function __construct(TemplateBlocks $templateBlocksService, ITemplateFactory $templateFactory, Paths $paths)
	{
		$this->templateBlocksService = $templateBlocksService;
		$this->templateFactory       = $templateFactory;
		$this->pathsService          = $paths;
	}

	public function loadContainer($formContainer, $params = [])
	{
		$items = [];
		foreach ($this->templateBlocksService->getEr()->createQueryBuilder('b')->select('b.id, b.title')
			         ->orderBy('b.title')->getQuery()->getArrayResult() as $b) {
			$items[$b['id']] = $b['title'];
		}

		$formContainer->addSortableCheckboxList($this->getName(), $this->getTitle(), $items);
	}

	/**
	 * @param $params
	 *
	 * @return mixed
	 */
	public function render($params)
	{
		$content = '';
		$inArray = [];

		foreach ($this->getDefault() as $id) {
			$block = $this->templateBlocksService->get($id) ?? null;

			if (!$block)
				continue;

			// TODO přesunout do služby
			$template                  = $block->template;
			$latte                     = $this->templateFactory->createTemplate();
			$latte->templateTextValues = $block->getTexts();
			$latte->setFile($this->pathsService->getTemplateBlocksFile($template));
			if (isset($params['toVar']))
				$inArray[] = $latte;
			else
				$content .= $latte->renderToString();
		}

		return isset($params['toVar']) ? $inArray : $content;
	}
}
