<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Boolean extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'bool';

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$c = $formContainer->addBool($this->getName(), $this->getTitle(), $params['items'] ?? []);
		if (isset($params['multiLang']))
			$c->setIsMultilanguage($params['multiLang']);
	}

	public function render($params)
	{
		return $this->getDefault();
	}
}
