<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Number extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'number';

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$c = $formContainer->addText($this->getName(), $this->getTitle())
			->setType('number');
		if (isset($params['multiLang']))
			$c->setIsMultilanguage($params['multiLang']);

		foreach (['step', 'min', 'max'] as $v)
			if (isset($params[$v]))
				$c->setAttribute($v, $params[$v]);
	}

	public function render($params)
	{
		return $this->getDefault();
	}
}
