<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Nette\Caching\Cache;
use Pages\FrontModule\Model\Dao\DaoTemplateBlock;
use Pages\Model\Entities\TemplateBlock;

/**
 * Class TemplateBlocks
 * @package Pages\FrontModule\Model
 */
class TemplateBlocks extends BaseFrontEntityService
{
	const CACHE_NAMESPACE = 'templateBlocks';

	protected $entityClass = TemplateBlock::class;

	/** @var array */
	protected $cacheDep = [
		Cache::TAGS    => [self::CACHE_NAMESPACE],
		Cache::EXPIRE  => '1 week',
		Cache::SLIDING => true,
	];

	public function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	public function get($id)
	{
		$lang = $this->translator->getLocale();
		$key  = self::CACHE_NAMESPACE . '/' . $id . '/' . $lang;

		return $this->getCache()->load($key, function(&$dep) use ($id, $lang) {
			$dep = $this->cacheDep;

			$templateBlock = $this->getEr()->createQueryBuilder('tb')
				->select('tb.id, tb.title, tbt.texts, tb.template')
				->join('tb.texts', 'tbt', 'WITH', 'tbt.lang = :lang')
				->where('tb.id = :id')
				->setParameters([
					'id'   => $id,
					'lang' => $lang,
				])
				->getQuery()->getOneOrNullResult();

			return $templateBlock ? $this->fillDao($templateBlock) : null;
		});
	}

	protected function fillDao(array $data): DaoTemplateBlock
	{
		$dao = new DaoTemplateBlock((int) $data['id'], $data['title'], $data['texts'], $data['template']);

		return $dao;
	}
}
