<?php declare(strict_types = 1);

namespace Pages\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Pages\Model\Entities\Page;
use Pages\Model\Pages;

class PagesGrid extends BaseControl
{
	/** @var Pages */
	protected $pagesService;

	public function __construct(Pages $pages)
	{
		$this->pagesService = $pages;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentGrid()
	{
		$grid = $this->createGrid();

		$qb = $this->pagesService->getEr()->createQueryBuilder('t');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'Pages:edit');

		// Filter
		$grid->addFilterText('title', 'default.title');

		// Actions
		$grid->addAction('edit', '', 'Pages:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')->setIcon('times')->setBsType('danger')->addClass('ajax');


		return $grid;
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */

	public function handleDelete($id)
	{
		$presenter = $this->getPresenter();
		if ($this->pagesService->remove($id))
			$presenter->flashMessageSuccess('default.removed');
		else
			$presenter->flashMessageDanger('default.removeFailed');

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else
			$presenter->redirect('this');
	}
}
