<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model;

use Core\Model\Helpers\BaseFrontEntityService;
use Nette\Caching\Cache;
use Pages\Model\Entities\TemplatePage;

/**
 * Class TemplatePages
 * @package Pages\FrontModule\Model
 */
class TemplatePages extends BaseFrontEntityService
{
	const CACHE_NAMESPACE = 'templatePages';

	protected $entityClass = TemplatePage::class;

	/** @var array */
	protected $cacheDep = [
		Cache::TAGS    => [self::CACHE_NAMESPACE],
		Cache::EXPIRE  => '1 week',
		Cache::SLIDING => true,
	];

	public function getCache()
	{
		if ($this->cache === null)
			$this->cache = new Cache($this->cacheStorage, self::CACHE_NAMESPACE);

		return $this->cache;
	}

	public function get($id)
	{
		$key = self::CACHE_NAMESPACE . '/' . $id;

		return $this->getCache()->load($key, function(&$dep) use ($id) {
			$dep = $this->cacheDep;

			$query = $this->getEr()->createQueryBuilder('p')->where('p.isPublished = 1')
				->andWhere('p.id = :id')->setParameter('id', $id)->getQuery();

			return $query->getOneOrNullResult();
		});
	}
}
