<?php declare(strict_types = 1);

namespace Pages\FrontModule\Presenters;

use Pages\Model\Pages;
use Pages\Model\Paths;
use Pages\FrontModule\Model\TemplatePages;

class DefaultPresenter extends BasePresenter
{
	/** @var Pages */
	protected $pagesService;

	/** @var TemplatePages */
	protected $templatePagesService;

	/** @var Paths */
	protected $pathsService;

	public function __construct(Pages $pages, TemplatePages $templatePages, Paths $paths)
	{
		$this->pagesService         = $pages;
		$this->templatePagesService = $templatePages;
		$this->pathsService         = $paths;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionPage($id)
	{
		$page = $this->pagesService->get($id);

		if (!$page || !$page->isPublished)
			$this->error('pages.page.notFound');

		$this->template->pageClass .= ' one-page';
		$this->template->page      = $page;
	}

	public function actionTemplatePage($id)
	{
		$id   = $id ?: $this->getActiveNavigation()->componentParams['templatePage'];
		$page = $this->templatePagesService->get($id);

		if (!$page || !$page->isPublished)
			$this->error('pages.page.notFound');

		$this->template->pageClass          .= ' template-page tp-' . $page->getId();
		$this->template->templateTextValues = $page->getTexts();
		$this->template->setFile($this->pathsService->getTemplatePagesFile($page->template));
	}

	/*******************************************************************************************************************
	 * ============================== Components
	 */
}
