<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="pages__page")
 * @ORM\Entity
 */
class Page
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var string
	 * @ORM\Column(name="title", type="string", length=255, nullable=false)
	 */
	public $title;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=false)
	 */
	public $isPublished;

	/**
	 * @var string
	 * @ORM\Column(name="text", type="text", nullable=true)
	 */
	public $text;

	/**
	 * Page constructor.
	 *
	 * @param string $title
	 * @param int    $isPublished
	 */
	public function __construct($title, $isPublished = 1)
	{
		$this->title       = $title;
		$this->isPublished = $isPublished;
	}
}