<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class File extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'file';

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$formContainer->addFilesManager($this->getName(), $this->getTitle());
	}

	public function render($params)
	{
		return $this->getDefault();
	}
}