<?php declare(strict_types = 1);

namespace Pages\Model\Templating\Filters;

use Nette\Utils\Html;
use Pages\FrontModule\Model\TemplateBlocks as FrontTemplateBlocks;
use Pages\Model\Paths;
use Nette\Application\UI\ITemplateFactory;

class TemplateBlock
{
	/** @var TemplateBlocks */
	protected $templateBlocks;

	/** @var FrontTemplateBlocks */
	protected $frontTemplateBlocks;

	/** @var ITemplateFactory */
	protected $templateFactory;

	/** @var Paths */
	protected $pathsService;

	/**
	 * TemplateBlock constructor.
	 *
	 * @param FrontTemplateBlocks $frontTemplateBlocks
	 * @param ITemplateFactory    $templateFactory
	 * @param Paths               $paths
	 */
	public function __construct(FrontTemplateBlocks $frontTemplateBlocks, ITemplateFactory $templateFactory, Paths $paths)
	{
		$this->frontTemplateBlocks = $frontTemplateBlocks;
		$this->templateFactory     = $templateFactory;
		$this->pathsService        = $paths;
	}

	public function __invoke($id)
	{
		$args  = func_get_args();
		$block = $this->frontTemplateBlocks->get($id);

		if (!$block)
			return '';

		// TODO přesunout do služby
		$template = $block->template;
		$latte    = $this->templateFactory->createTemplate();

		if (isset($args[1]))
			$latte->presenter = $args[1];
		$latte->templateTextValues = $block->getTexts();
		$latte->setFile($this->pathsService->getTemplateBlocksFile($template));

		return (new Html())->setHtml($latte->renderToString());
	}
}
