<?php declare(strict_types = 1);

namespace Pages\Model\Navigation;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\UI\Form\BaseForm;
use Navigations\Model\Entities\Navigation;
use Navigations\Model\Providers\INavigationItem;
use Nette\Utils\ArrayHash;
use Pages\Model\Pages;
use Pages\AdminModule\Model\TemplatePages;

class TemplatePage extends BaseNavigation implements INavigationItem
{
	protected $title     = 'templatePage';
	protected $presenter = 'Pages:Front:Default';
	protected $action    = 'templatePage';

	/** @var Pages */
	protected $templatePagesService;

	public function __construct(TemplatePages $templatePages)
	{
		$this->templatePagesService = $templatePages;
	}

	/**
	 * @return BaseContainer
	 */
	public function getFormContainer()
	{
		$container = new BaseContainer();

		$pages = [];
		foreach ($this->templatePagesService->getAll() as $page)
			$pages[$page->getId()] = $page->title;

		$container->addSelect('templatePage', 'pages.navigationForm.page', $pages)->setRequired();

		return $container;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
	}

	/*******************************************************************************************************************
	 * ===========================  Route
	 */

	public function presenterActionCheck($presenter, $action)
	{
		return (
			$this->presenter == $presenter && $this->action == $action
		);
	}

	public function routerIn($navigation, $urlParams = [])
	{
		return [
			'presenter' => $this->presenter,
			'action'    => $this->action,
			'id'        => $navigation->componentParams['templatePage'],
		];
	}

	public function routerOut(DaoNavigationItem $navigation, &$urlParams): ?string
	{
		return $navigation->isHomepage ? '/' : '/' . $navigation->alias;
	}
}
