<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Editor extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'editor';

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
		$editor = $formContainer->addEditor($this->getName(), $this->getTitle())
			->setDisableAutoP($params['disableAutoP'] ?? true);
		if (isset($params['buttons']))
			$editor->setToolbarButtons($params['buttons']);
		else if (isset($params['toolbar']))
			$editor->setToolbar($params['toolbar']);

		if (isset($params['styles']))
			$editor->setStyles($params['styles']);
		if (isset($params['height']))
			$editor->setHeight($params['height']);
		if (isset($params['multiLang']))
			$editor->setIsMultilanguage($params['multiLang']);
	}

	public function render($params)
	{
		return $this->getDefault();
	}
}
