document.addEventListener('DOMContentLoaded', () => {
	let inProcess = false;

	// Nastavení správných stránek do selectu v navigaci
	document.addEventListener('change', e => {
		let target = e.target;

		if (target.id.indexOf('navigationForm-form-site') !== -1) {
			let templatePageSelect = target.form.querySelector('[name="component[templatePage]"]');

			if (templatePageSelect && inProcess === false) {
				e.stopImmediatePropagation();
				inProcess = true;

				global.naja.makeRequest('post', templatePageSelect.dataset.customLink, {
					componentData: {
						site: target.value,
					},
				}, {
					history: false,
				}).complete(response => {
					inProcess = false;
				});
			}
		}
	});
});
