<?php declare(strict_types = 1);

namespace Pages\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\DataGrid\BaseDataGrid;
use Nette\Application\AbortException;
use Pages\AdminModule\Model\TemplateBlocks;

class TemplateBlocksGrid extends BaseControl
{
	public function __construct(protected TemplateBlocks $templateBlocksService)
	{
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Handle
	 */
	/**
	 * @throws AbortException
	 */
	public function handleDelete(int|string $id): void
	{
		$presenter = $this->presenter;
		if ($this->templateBlocksService->remove($id)) {
			$presenter->flashMessageSuccess('default.removed');
		} else {
			$presenter->flashMessageDanger('default.removeFailed');
		}

		if ($presenter->isAjax()) {
			$this['grid']->reload();
			$presenter->redrawControl('flashes');
		} else {
			$presenter->redirect('this');
		}
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentGrid(): BaseDataGrid
	{
		$grid = $this->createGrid();

		$qb = $this->templateBlocksService->getEr()->createQueryBuilder('p');
		$grid->setDataSource($qb);

		// Columns
		$grid->addColumnLink('title', 'default.title', 'TemplateBlocks:edit');

		// Filter
		$grid->addFilterText('title', 'default.title');

		// Actions
		$grid->addAction('edit', '', 'TemplateBlocks:edit')->setIcon('edit')->setBsType('primary');
		$grid->addAction('delete', '', 'delete!')
			->setIcon('times')
			->setConfirm('default.reallyDelete')
			->setBsType('danger')
			->addClass('ajax');

		return $grid;
	}
}
