<?php declare(strict_types = 1);

namespace Pages\ApiModule\Api\V1\Controllers;

use Apitte\Core\Annotation\Controller\Method;
use Apitte\Core\Annotation\Controller\Path;
use Apitte\Core\Annotation\Controller\RequestParameter;
use Apitte\Core\Annotation\Controller\RequestParameters;
use Apitte\Core\Http\ApiRequest;
use Apitte\Core\Http\ApiResponse;
use Pages\FrontModule\Model\TemplatePages;

/**
 * @Path("/template-page")
 */
class TemplatePageController extends BaseController
{
	protected TemplatePages $templatePages;

	public function __construct(TemplatePages $templatePages)
	{
		$this->templatePages = $templatePages;
	}

	/**
	 * @Path("/detail/{id}")
	 * @Method("GET")
	 * @RequestParameters({
	 *      @RequestParameter(name="id", type="int", required=true)
	 * })
	 */
	public function detail(ApiRequest $request, ApiResponse $response): ApiResponse
	{
		$templatePage = null;
		if ($tp = $this->templatePages->get((int) $request->getParameter('id'))) {
			$templatePage = $tp->toArray();
		}

		return $response->writeJsonBody(['templatePage' => $templatePage])->withStatus(ApiResponse::S200_OK);
	}

}
