<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model\Dao;

use Nette\SmartObject;

/**
 * @property-read int    $id
 * @property-read string $title
 * @property-read array  $texts
 * @property-read string $template
 */
class DaoTemplateBlock
{
	use SmartObject;

	public function __construct(
		protected int    $id,
		protected string $title,
		protected array  $texts,
		protected string $template,
	)
	{
	}

	public function getId(): int { return $this->id; }

	public function getTitle(): string { return $this->title; }

	public function getTexts(): array { return $this->texts; }

	public function getText(string $key): ?string { return $this->texts[$key] ?? null; }

	public function getTemplate(): string { return $this->template; }

}
