<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\PostPersistEventArgs;
use Doctrine\ORM\Event\PostRemoveEventArgs;
use Doctrine\ORM\Event\PostUpdateEventArgs;
use Doctrine\ORM\Mapping as ORM;
use Nette\Caching\Cache;
use Nette\Caching\Storage;
use Nette\SmartObject;
use Pages\FrontModule\Model\TemplateBlocks;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateBlockListener implements EventSubscriberInterface
{
	use SmartObject;

	private Cache $cache;

	public function __construct(
		protected Storage $cacheStorage,
	)
	{
		$this->cache = new Cache($cacheStorage, TemplateBlocks::CACHE_NAMESPACE);
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	#[ORM\PostPersist]
	#[ORM\PostUpdate]
	#[ORM\PostRemove]
	public function postHandler(TemplateBlock $templateBlock, PostPersistEventArgs|PostUpdateEventArgs|PostRemoveEventArgs $event): void
	{
		$this->cache->clean([
			Cache::Tags => [TemplateBlocks::CACHE_NAMESPACE],
		]);
	}
}
