<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\Site;
use Core\Model\Entities\TId;
use Core\Model\Entities\TranslateListener;
use Core\Model\Entities\TTranslateListener;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\DBAL\Types\Types;
use Doctrine\ORM\Mapping as ORM;

#[ORM\Table(name: 'pages__template_page')]
#[ORM\Entity]
#[ORM\EntityListeners([TemplatePageListener::class, TranslateListener::class])]
class TemplatePage implements ITemplate
{
	use TId;
	use TTranslateListener;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public string $title;

	#[ORM\ManyToOne(targetEntity: Site::class)]
	#[ORM\JoinColumn(name: 'site', referencedColumnName: 'ident', onDelete: 'CASCADE')]
	public ?Site $site;

	/**
	 * @var Collection<string, TemplatePageText>
	 */
	#[ORM\OneToMany(targetEntity: TemplatePageText::class, mappedBy: 'page', indexBy: 'lang')]
	public Collection $texts;

	#[ORM\Column(type: Types::STRING, length: 255, nullable: false)]
	public ?string $template;

	#[ORM\ManyToOne(targetEntity: TemplatePageGroup::class, inversedBy: 'pages')]
	#[ORM\JoinColumn(name: 'group_id', referencedColumnName: 'id', nullable: true, onDelete: 'SET NULL')]
	public ?TemplatePageGroup $group = null;

	public function __construct(string $title, string $template)
	{
		$this->title    = $title;
		$this->template = $template;
		$this->texts    = new ArrayCollection;
	}

	public function setTexts($texts): self
	{
		$this->texts = new ArrayCollection((array) $texts);

		return $this;
	}

	public function getText($lang = null): ?TemplatePageText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return array */
	public function getTexts() { return []; }

	public function getPreviewHash(): string
	{
		return md5(implode('_', [
				$this->getId(),
				$this->site ? $this->site->getIdent() : '',
				$this->template,
			])
		);
	}
}
