<?php declare(strict_types = 1);

namespace Pages\Model\Helpers;

use Core\Model\Settings;
use Core\Model\Sites;

class TemplatePagesHelper
{
	public function __construct(protected Settings $settings, protected Sites $sites)
	{
	}

	public function checkTexts(array $texts): array
	{
		$site         = $this->sites->getCurrentSite();
		$siteSettings = $this->settings->getPrefixed($site->getIdent() . '_webSettings');

		$loop = static function(array &$texts) use (&$loop, $siteSettings, $site) {
			foreach ($texts as &$text) {
				if (is_array($text)) {
					$loop($text);
					continue;
				}

				if (is_object($text) || is_bool($text)) {
					continue;
				}

				if (is_numeric($text)) {
					$text = (string) $text;
				}

				if ($text) {
					$text = str_replace('{siteEmail}', $site->getEmail(), $text);

					foreach ($siteSettings as $k => $v) {
						$text = str_replace('{site' . ucfirst($k) . '}', (string) $v, $text);
					}
				}
			}
		};

		$loop($texts);

		return $texts;
	}
}
