<?php declare(strict_types = 1);

namespace Pages\Model;

use Core\Model\Parameters;

class Paths
{
	public function getTemplatePagesDir(string $site = 'default'): string
	{
		$templateDirs = Parameters::load('system.templatePagesDir') ?? [];

		if (isset($templateDirs[$site])) {
			return $this->parsePathParams($templateDirs[$site]);
		}

		return TEMPLATES_DIR . '/Front/' . $site . '/Pages/TemplatePages';
	}

	public function getTemplatePagesFile(string $name, string $site = 'default'): string
	{
		$tmp = explode('|', $name);

		if (count($tmp) === 2) {
			$name = $tmp[1];
			$site = $tmp[0];
		}

		return $this->getTemplatePagesDir($site) . '/' . $name;
	}

	public function getTemplateBlocksDir(?string $key = null): string
	{
		$templateDirs = Parameters::load('system.templateBlocksDir') ?? [];

		if (isset($templateDirs[$key])) {
			return $this->parsePathParams($templateDirs[$key]);
		}

		return TEMPLATES_DIR . '/Front/default/Pages/TemplateBlocks';
	}

	public function getTemplateBlocksFile(string $name, string $key = 'default'): string
	{
		$tmp = explode('|', $name);

		if (count($tmp) === 2) {
			$name = $tmp[1];
			$key  = $tmp[0];
		}

		return $this->getTemplateBlocksDir($key) . '/' . $name;
	}

	public function getTemplateCustomDir(string $key, array $dirList): ?string
	{
		if (isset($dirList[$key])) {
			return $this->parsePathParams($dirList[$key]);
		}

		return null;
	}

	public function parsePathParams(string $val): string
	{
		return str_replace('%appDir%', APP_DIR, $val);
	}
}
