<?php declare(strict_types = 1);

namespace Pages\Model;

use Core\Model\Router\RouteHelper;
use Core\Model\Router\RouteList;

class RouterFactory
{
	protected RouteHelper $routeHelper;

	public function __construct(
		RouteHelper $routeHelper
	)
	{
		$this->routeHelper = $routeHelper;
	}

	public function createRouter(): RouteList
	{
		$router = new RouteList;

		$front   = $router[] = new RouteList('Pages:Front');
		$front[] = $this->routeHelper->createRoute('/pages/template-page/preview', 'Default:preview');

		return $router;
	}

}
