<?php declare(strict_types = 1);

namespace Pages\Model\Subscribers;

use Core\Model\Event\TemplateFactoryEvent;
use Pages\FrontModule\Model\TemplatePages;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

class TemplateSubscriber implements EventSubscriberInterface
{
	public function __construct(protected TemplatePages $templatePages)
	{
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'templateFactory::createTemplate' => 'createTemplate',
		];
	}

	public function createTemplate(TemplateFactoryEvent $event): void
	{
		$event->template->templatePages = $this->templatePages;
	}
}
