<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\Templating\TemplateFactory;
use Pages\FrontModule\Model\TemplateBlocks;
use Pages\Model\Entities\TemplateBlock;
use Pages\Model\Paths;

class Block extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'block';

	public function __construct(
		protected TemplateBlocks  $templateBlocksService,
		protected TemplateFactory $templateFactory,
		protected Paths           $pathsService,
	)
	{
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$blocks = ['' => ''];
		/** @var TemplateBlock[] $allBlocks */
		$allBlocks = $this->templateBlocksService->getEr()->findBy([], ['title' => 'ASC']);
		foreach ($allBlocks as $b) {
			$blocks[$b->getId()] = $b->title;
		}

		$formContainer->addSelect($this->getName(), $this->getTitle(), $blocks);
	}

	public function render(array $params)
	{
		if ($params['return'] === 'id') {
			return $this->getDefault();
		}

		$block = $this->templateBlocksService->get($this->getDefault());

		if (!$block) {
			return '';
		}

		// TODO přesunout do služby
		$template                  = $block->template;
		$latte                     = $this->templateFactory->createTemplate();
		$latte->templateTextValues = $block->getTexts();
		$latte->setFile($this->pathsService->getTemplateBlocksFile($template));

		return $latte;
	}
}
