<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use Core\Model\UI\Form\Controls\CheckboxInput;

class Checkbox extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'checkbox';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		/** @var CheckboxInput $c */
		$c = $formContainer->addCheckbox($this->getName(), $this->getTitle());

		if (isset($params['default'])) {
			$formContainer->getComponent($this->getName())->setDefaultValue($params['default']);
		}

		if (isset($params['multiLang'])) {
			$c->setIsMultilanguage($params['multiLang']);
		}
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}
}
