<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class File extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'file';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$c = $formContainer->addFilesManager($this->getName(), $this->getTitle());
		if (isset($params['multiLang'])) {
			$c->setIsMultilanguage($params['multiLang']);
		}

		if (isset($params['multiple']) && $params['multiple'] == true) {
			$c->multiple = true;
		}
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}
}
