<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Contributte\Translation\Translator;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Video extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'video';

	public const resolution1080 = '1080';
	public const resolution720  = '720';
	public const resolution480  = '480';

	public const resolutionsList = [
		self::resolution1080 => '1080',
		self::resolution720  => '720',
		self::resolution480  => '480',
	];

	protected Translator $translator;

	public function __construct(
		Translator $translator
	)
	{
		$this->translator = $translator;
	}

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$container = $formContainer->addContainerWithLabel($this->getName(), $this->getTitle());
		$container->addCustomData('ttType', self::class);

		foreach (self::resolutionsList as $v) {
			$container->addFilesManager('v' . $v, 'pages.templateTextType.video.' . $v);
		}

		if (isset($params['multiLang'])) {
			$container->addCustomData('multiLang', true);
			foreach (self::resolutionsList as $v) {
				$container->getComponent('v' . $v)->setIsMultilanguage($params['multiLang']);
			}
		}
	}

	public function render(array $params)
	{
		$result   = [];
		$defaults = $this->getDefault();

		if (!is_array($defaults)) {
			return null;
		}

		foreach (self::resolutionsList as $v) {
			if (array_key_exists('v' . $v, $defaults)) {
				$result[$v] = $defaults['v' . $v] ?: null;
			}
		}

		return array_filter($result, 'is_null') === $result ? null : $result;
	}
}
