<?php declare(strict_types = 1);

namespace Pages\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;

class Window extends TemplateTextType implements ITemplateTextType
{
	protected $type = 'window';

	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (!isset($params['url']) || empty($params['url'])) {
			throw new InvalidArgumentException('Please define url attr in tt');
		}

		$formContainer->addWindow($this->getName(), $params['url'], $this->getTitle())
			->setDescription($params['description'] ?? null);
	}

	public function render(array $params)
	{
		return $this->getDefault();
	}
}
