<?php declare(strict_types = 1);

namespace Pages\AdminModule\Components;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Utils\ArrayHash;
use Pages\AdminModule\Model\TemplatePageGroups;
use Pages\Model\Entities\TemplatePageGroup;
use Tracy\Debugger;
use Tracy\ILogger;

class TemplatePageGroupForm extends BaseControl
{
	/** @var int|null @persistent */
	public ?int                  $id = null;
	protected TemplatePageGroups $templatePageGroups;

	public function __construct(
		TemplatePageGroups $templatePageGroups
	)
	{
		$this->templatePageGroups = $templatePageGroups;
	}

	public function render(): void
	{
		$this->template->thisForm = $this['form'];

		$this->template->render($this->getTemplateFile());
	}

	/*******************************************************************************************************************
	 * ==================  Components
	 */

	protected function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->setAjax();

		$form->addText('title', 'default.title')->setRequired()->setMaxLength(255);

		$form->addSaveCancelControl();

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		try {
			if ($this->id) {
				$group          = $this->templatePageGroups->get($this->id);
				$successMessage = 'pages.templatePageGroup.edited';
			} else {
				$group          = new TemplatePageGroup($values->title);
				$successMessage = 'pages.templatePageGroup.added';
			}

			$group->title = $values->title;

			$this->em->persist($group);
			$this->em->flush();


			$form->addCustomData('templatePageGroupId', $group->getId());
			$this->presenter->flashMessageSuccess($successMessage);

			return true;
		} catch (\Exception $e) {
			$this->presenter->flashMessageDanger('default.error');
			Debugger::log($e, ILogger::EXCEPTION);
		}

		return false;
	}

	/*******************************************************************************************************************
	 * ==================  GET / SET
	 */

	public function setGroup(int $id): void
	{
		$group = $this->templatePageGroups->get($id);

		if (!$group) {
			$this->presenter->error();
		}

		$this->id = $id;

		$form = $this['form'];
		$form->setDefaults([
			'title' => $group->title,
		]);
	}
}
