<?php declare(strict_types = 1);

namespace Pages\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Pages\Model\Entities\TemplatePageGroup;

/**
 * @method TemplatePageGroup|null getReference($id)
 * @method TemplatePageGroup[]|null getAll()
 * @method TemplatePageGroup|null get($id)
 */
class TemplatePageGroups extends BaseEntityService
{
	protected $entityClass = TemplatePageGroup::class;

	protected ?array $cOptionsForSelect = null;

	/**
	 * @return string[]
	 */
	public function getOptionsForSelectGrouped(): array
	{
		if ($this->cOptionsForSelect === null) {
			$this->cOptionsForSelect = [];

			foreach ($this->getEr()->createQueryBuilder('tpg')
				         ->select('tpg.id, tpg.title')
				         ->orderBy('tpg.title')->getQuery()->getArrayResult() as $row) {
				$this->cOptionsForSelect[$row['id']] = $row['title'];
			}
		}

		return $this->cOptionsForSelect;
	}
}
