<?php declare(strict_types = 1);

namespace Pages\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Pages\Model\Entities\TemplatePage;

/**
 * @method TemplatePage|null getReference($id)
 * @method TemplatePage[]|null getAll()
 * @method TemplatePage|null get($id)
 */
class TemplatePages extends BaseEntityService
{
	protected $entityClass = TemplatePage::class;

	protected ?array $cOptionsForSelectGrouped = null;

	/**
	 * @return string[]
	 */
	public function getOptionsForSelectGrouped(): array
	{
		if ($this->cOptionsForSelectGrouped === null) {
			$this->cOptionsForSelectGrouped = [];

			foreach ($this->getEr()->createQueryBuilder('tp')
				         ->select('tp.id, tp.title, IDENTITY(tp.site) as site, g.title as group')
				         ->leftJoin('tp.group', 'g')
				         ->orderBy('group')->addOrderBy('tp.title')->getQuery()->getArrayResult() as $row) {
				$title = $row['title'];
				if ($row['group']) {
					$title = $row['group'] . ' - ' . $title;
				}

				$this->cOptionsForSelectGrouped[$row['site']][$row['id']] = $title;
			}

			if (count($this->cOptionsForSelectGrouped) === 1) {
				$this->cOptionsForSelectGrouped = array_values($this->cOptionsForSelectGrouped)[0];
			}
		}

		return $this->cOptionsForSelectGrouped;
	}

	/**
	 * @param string $site
	 *
	 * @return array|string
	 * @deprecated use getOptionsForSelectGrouped()
	 */
	public function getBySiteForSelectOption(string $site)
	{
		return $this->getOptionsForSelectGrouped()[$site] ?? $this->getOptionsForSelectGrouped();
	}
}
