<?php declare(strict_types = 1);

namespace Pages\DI;

use Core\DI\CompilerExtension;
use Nette;

class PagesExtension extends CompilerExtension
{

	public function loadConfiguration(): void
	{
		parent::loadConfiguration();
		$this->setConfig($this->loadFromFile(__DIR__ . '/config.neon'));

		$this->compiler->loadDefinitionsFromConfig($this->loadFromFile(__DIR__ . '/services.neon'));
	}

	public function beforeCompile(): void
	{
		parent::beforeCompile();
		$this->setMapping(['Pages' => 'Pages\*Module\Presenters\*Presenter']);

		$builder = $this->getContainerBuilder();

		/** @var Nette\DI\Definitions\ServiceDefinition $def */
		$def = $builder->getDefinition('nette.latteFactory');
		$def->addSetup('addFilter', ['templateBlock', $builder->getDefinition('pages.filters.templateBlock')]);
	}

	public function afterCompile(Nette\PhpGenerator\ClassType $class): void
	{
		parent::afterCompile($class);
		$init = $class->methods['initialize'];

		$init->addBody('Pages\Model\PagesConfig::setParams($this->parameters[\'pages\']);');
	}
}
