<?php declare(strict_types = 1);

namespace Pages\FrontModule\Model\Dao;

use Nette\SmartObject;

class DaoTemplatePage
{
	use SmartObject;

	protected int    $id;
	protected string $title;
	protected array  $texts = [];
	protected string $template;
	public ?string   $site  = null;

	public function __construct(
		int    $id,
		string $title,
		array  $texts,
		string $template
	)
	{
		$this->id       = $id;
		$this->title    = $title;
		$this->texts    = $texts;
		$this->template = $template;
	}

	public function getId(): int { return $this->id; }

	public function getTitle(): string { return $this->title; }

	public function getTexts(): array { return $this->texts; }

	/**
	 * @return mixed|null
	 */
	public function getText(string $key) { return $this->texts[$key] ?? null; }

	public function getTemplate(): string { return $this->template; }

	public function toArray(): array
	{
		return [
			'id'       => $this->getId(),
			'title'    => $this->getTitle(),
			'texts'    => $this->getTexts(),
			'template' => $this->getTemplate(),
		];
	}

	public function getPreviewHash(): string
	{
		return md5(implode('_', [
				$this->getId(),
				$this->site ?: '',
				$this->template,
			])
		);
	}
}
