<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="pages__template_block")
 * @ORM\Entity
 * @ORM\EntityListeners({"TemplateBlockListener", "Core\Model\Entities\TranslateListener"})
 */
class TemplateBlock implements ITemplate
{
	use TId;
	use TTranslateListener;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $title;

	/**
	 * @var Collection<string, TemplateBlockText>
	 * @ORM\OneToMany(targetEntity="TemplateBlockText", mappedBy="block", indexBy="lang")
	 */
	public Collection $texts;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $template;

	public function __construct(string $title, string $template)
	{
		$this->title    = $title;
		$this->template = $template;
		$this->texts    = new ArrayCollection;
	}

	public function setTexts($texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText($lang = null): ?TemplateBlockText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return array */
	public function getTexts() { return []; }
}
