<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\ORM\Mapping as ORM;
use Nette\Utils\Json;

/**
 * @ORM\Table(name="pages__template_block_text")
 * @ORM\Entity
 */
class TemplateBlockText implements ITemplate
{

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="TemplateBlock", inversedBy="texts")
	 * @ORM\JoinColumn(name="block_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public TemplateBlock $block;

	/**
	 * @ORM\Id
	 * @ORM\Column(type="string", length=2, nullable=true)
	 */
	protected ?string $lang;

	/**
	 * @var int
	 * @ORM\Column(type="smallint", nullable=false, options={"default": 1})
	 */
	public $isPublished;

	/**
	 * @ORM\Column(type="array")
	 */
	protected array $texts;

	public function __construct(TemplateBlock $block, string $lang)
	{
		$this->block       = $block;
		$this->isPublished = 1;
		$this->texts       = [];
		$this->setLang($lang);
	}

	public function getLang(): string { return $this->lang; }

	public function setLang(?string $lang): self
	{
		$this->lang = $lang === '' ? null : $lang;

		return $this;
	}

	public function getTexts(): array { return $this->texts; }

	/**
	 * @param string $key
	 * @return string
	 */
	public function getText($key) { return $this->texts[$key] ?? ''; }

	public function setTexts($texts): void
	{
		$this->texts = is_array($texts) ? $texts : Json::decode($texts, Json::FORCE_ARRAY);
	}
}
