<?php declare(strict_types = 1);

namespace Pages\Model\Entities;

use Core\Model\Entities\Site;
use Core\Model\Entities\TTranslateListener;
use Core\Model\TemplateReader\Entity\ITemplate;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="pages__template_page")
 * @ORM\Entity
 * @ORM\EntityListeners({"TemplatePageListener", "Core\Model\Entities\TranslateListener"})
 */
class TemplatePage implements ITemplate
{
	use TId;
	use TTranslateListener;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public string $title;

	/**
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site", referencedColumnName="ident", onDelete="CASCADE")
	 */
	public ?Site $site;

	/**
	 * @var Collection<string, TemplatePageText>
	 * @ORM\OneToMany(targetEntity="TemplatePageText", mappedBy="page", indexBy="lang")
	 */
	public Collection $texts;

	/**
	 * @ORM\Column(type="string", length=255, nullable=false)
	 */
	public ?string $template;

	/**
	 * @ORM\ManyToOne(targetEntity="TemplatePageGroup", inversedBy="pages")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="SET NULL", nullable=true)
	 */
	public ?TemplatePageGroup $group = null;

	public function __construct(string $title, string $template)
	{
		$this->title    = $title;
		$this->template = $template;
		$this->texts    = new ArrayCollection;
	}

	public function setTexts($texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}

	public function getText($lang = null): ?TemplatePageText { return $this->texts[$lang ?: $this->locale] ?? null; }

	/** @return array */
	public function getTexts() { return []; }

	public function getPreviewHash(): string
	{
		return md5(implode('_', [
				$this->getId(),
				$this->site ? $this->site->getIdent() : '',
				$this->template,
			])
		);
	}
}
